/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;
// uniform vec2 mouse;
// uniform vec2 resolution;

float map(vec3 p) {
	float  t = length(mod(p.xz, 2.0) - 1.0) - 0.97;
	t = max(-t, 3.0 - dot(p, vec3(0, 1, 0)) + (sin(p.x * 0.3) * sin(p.z * 0.6)));
	t = min(t, length(mod(p.xz, 10.0) - 5.0) - 0.2);
	t = min(t, length(mod(p.xy, 10.0) - 5.0) - 0.2);
	t = min(t, length(mod(p.yz, 10.0) - 5.0) - 0.2);
	return t;
}

vec2 rot(vec2 p, float t)
{
	return vec2(
		cos(t) * p.x - sin(t) * p.y,
		sin(t) * p.x + cos(t) * p.y);
		
}
void main( void ) {

	vec2 uv = ( scaled_gl_FragCoord.xy / resolution.xy ) * 2.0 - 1.0;
	uv.x   *= resolution.x / resolution.y;
	uv.y    = -uv.y;
//	if(abs(uv.y) > 0.75) discard; // Removed by TheEmu
	
	vec3 dir = normalize(vec3(uv, 1));
	//dir.xz = rot(dir.xz, time * 0.1);
	//dir.yx = rot(dir.yx, time * 0.1);
	vec3 pos = vec3(sin(time * 7.0) * 0.01, cos(time * 5.0) * 0.02, time);
	float t = fract(dot(sin(time * 2465.0) * 5.17878, sin(time * 441.0)));
	for(int i = 0 ; i < 100; i++) {
		float temp = map(pos + dir * t) * 0.75;
		if(temp <  0.01) break;
		t += temp;
	}
	vec3 ip = pos + dir * t;
	gl_FragColor = vec4(t * 0.04) * map(ip - 0.2) + t * 0.015;
	gl_FragColor.a = 1.0;
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}